const express = require('express');
const router = express.Router();
const ExamenAuxiliarController = require('../controllers/examenauxiliares.controller');

// GET all ExamenAuxiliars
router.get('/', ExamenAuxiliarController.getAllExamenAuxiliars);

// GET ExamenAuxiliar by id
router.get('/:id', ExamenAuxiliarController.getExamenAuxiliarById);

// POST a new ExamenAuxiliar
router.post('/create', ExamenAuxiliarController.createExamenAuxiliar);

// PUT update an existing ExamenAuxiliar
router.put('/update/:id', ExamenAuxiliarController.updateExamenAuxiliar);

// DELETE an existing ExamenAuxiliar
// muy probable no considerar esta opción
// router.delete('/:id', ExamenAuxiliarController.deleteExamenAuxiliar);

// para los filtros de ExamenAuxiliar
router.get('/search/paciente/:codigo', ExamenAuxiliarController.getExamenAuxiliarByPaciente);

module.exports = router;
