const express = require('express');
const router = express.Router();
const ExamenEstomatologicoController = require('../controllers/examenestomatologico.controller');

// GET all ExamenEstomatologicos
router.get('/', ExamenEstomatologicoController.getAllExamenEstomatologicos);

// GET ExamenEstomatologico by id
router.get('/:id', ExamenEstomatologicoController.getExamenEstomatologicoById);

// POST a new ExamenEstomatologico
router.post('/create', ExamenEstomatologicoController.createExamenEstomatologico);

// PUT update an existing ExamenEstomatologico
router.put('/update/:id', ExamenEstomatologicoController.updateExamenEstomatologico);

// DELETE an existing ExamenEstomatologico
// muy probable no considerar esta opción
// router.delete('/:id', ExamenEstomatologicoController.deleteExamenEstomatologico);

// para los filtros de ExamenEstomatologico
router.get('/search/paciente/:codigo', ExamenEstomatologicoController.getExamenEstomatologicoByPaciente);

module.exports = router;
