const express = require('express');
const router = express.Router();
const InformeQuirurgicoController = require('../controllers/informequirurgico.controller');

// GET all InformeQuirurgicos
router.get('/', InformeQuirurgicoController.getAllInformeQuirurgicos);

// GET InformeQuirurgico by id
router.get('/:id', InformeQuirurgicoController.getInformeQuirurgicoById);

// POST a new InformeQuirurgico
router.post('/create', InformeQuirurgicoController.createInformeQuirurgico);

// PUT update an existing InformeQuirurgico
router.put('/update/:id', InformeQuirurgicoController.updateInformeQuirurgico);

// DELETE an existing InformeQuirurgico
// muy probable no considerar esta opción
// router.delete('/:id', InformeQuirurgicoController.deleteInformeQuirurgico);

// para los filtros de InformeQuirurgico
router.get('/search/cirugia/:codigo', InformeQuirurgicoController.getInformeQuirurgicoByCirugia);

module.exports = router;
