const express = require('express');
const router = express.Router();
const InterpretacionRadiograficaController = require('../controllers/interpretacionradiografica.controller');

// GET all InterpretacionRadiograficas
router.get('/', InterpretacionRadiograficaController.getAllInterpretacionRadiograficas);

// GET InterpretacionRadiografica by id
router.get('/:id', InterpretacionRadiograficaController.getInterpretacionRadiograficaById);

// POST a new InterpretacionRadiografica
router.post('/create', InterpretacionRadiograficaController.createInterpretacionRadiografica);

// PUT update an existing InterpretacionRadiografica
router.put('/update/:id', InterpretacionRadiograficaController.updateInterpretacionRadiografica);

// DELETE an existing InterpretacionRadiografica
// muy probable no considerar esta opción
// router.delete('/:id', InterpretacionRadiograficaController.deleteInterpretacionRadiografica);

// para los filtros de InterpretacionRadiografica
router.get('/search/cirugia/:codigo', InterpretacionRadiograficaController.getInterpretacionRadiograficaByCirugia);

module.exports = router;
