const express = require('express');
const router = express.Router();
const ManifestacionEndodonciaController = require('../controllers/manifestacionendodoncia.controller');

// GET all ManifestacionEndodoncias
router.get('/', ManifestacionEndodonciaController.getAllManifestacionEndodoncias);

// GET ManifestacionEndodoncia by id
router.get('/:id', ManifestacionEndodonciaController.getManifestacionEndodonciaById);

// POST a new ManifestacionEndodoncia
router.post('/create', ManifestacionEndodonciaController.createManifestacionEndodoncia);

// PUT update an existing ManifestacionEndodoncia
router.put('/update/:id', ManifestacionEndodonciaController.updateManifestacionEndodoncia);

// DELETE an existing ManifestacionEndodoncia
// muy probable no considerar esta opción
// router.delete('/:id', ManifestacionEndodonciaController.deleteManifestacionEndodoncia);

// para los filtros de ManifestacionEndodoncia
router.get('/search/endodoncia/:codigo', ManifestacionEndodonciaController.getManifestacionEndodonciaByEndodoncia);

module.exports = router;
