const express = require('express');
const router = express.Router();
const NotasEvolutivasController = require('../controllers/notasevolutivas.controller');

// GET all NotasEvolutivass
router.get('/', NotasEvolutivasController.getAllNotasEvolutivass);

// GET NotasEvolutivas by id
router.get('/:id', NotasEvolutivasController.getNotasEvolutivasById);

// POST a new NotasEvolutivas
router.post('/create', NotasEvolutivasController.createNotasEvolutivas);

// PUT update an existing NotasEvolutivas
router.put('/update/:id', NotasEvolutivasController.updateNotasEvolutivas);

// DELETE an existing NotasEvolutivas
// muy probable no considerar esta opción
// router.delete('/:id', NotasEvolutivasController.deleteNotasEvolutivas);

// para los filtros de NotasEvolutivas
router.get('/search/paciente/:codigo', NotasEvolutivasController.getNotasEvolutivasByPaciente);

module.exports = router;
