const express = require('express');
const router = express.Router();
const ObturaciondeConductosController = require('../controllers/obturaciondeconductos.controller');

// GET all ObturaciondeConductoss
router.get('/', ObturaciondeConductosController.getAllObturaciondeConductoss);

// GET ObturaciondeConductos by id
router.get('/:id', ObturaciondeConductosController.getObturaciondeConductosById);

// POST a new ObturaciondeConductos
router.post('/create', ObturaciondeConductosController.createObturaciondeConductos);

// PUT update an existing ObturaciondeConductos
router.put('/update/:id', ObturaciondeConductosController.updateObturaciondeConductos);

// DELETE an existing ObturaciondeConductos
// muy probable no considerar esta opción
// router.delete('/:id', ObturaciondeConductosController.deleteObturaciondeConductos);

// para los filtros de ObturaciondeConductos
router.get('/search/endodoncia/:codigo', ObturaciondeConductosController.getObturaciondeConductosByEndodoncia);

module.exports = router;
