const express = require('express');
const router = express.Router();
const OdontogramaController = require('../controllers/odontograma.controller');

// GET all Odontogramas
router.get('/', OdontogramaController.getAllOdontogramas);

// GET Odontograma by id
router.get('/:id', OdontogramaController.getOdontogramaById);

// POST a new Odontograma
router.post('/create', OdontogramaController.createOdontograma);

// PUT update an existing Odontograma
router.put('/update/:id', OdontogramaController.updateOdontograma);

// DELETE an existing Odontograma
// muy probable no considerar esta opción
// router.delete('/:id', OdontogramaController.deleteOdontograma);

// para los filtros de Odontograma
router.get('/paciente/:codigo', OdontogramaController.getOdontogramaByPaciente);

module.exports = router;
