const express = require('express');
const router = express.Router();
const PeriodoController = require('../controllers/periodo.controller');

// GET all Periodos
router.get('/', PeriodoController.getAllPeriodos);

// GET Periodo by id
router.get('/:id', PeriodoController.getPeriodoById);

// POST a new Periodo
router.post('/create', PeriodoController.createPeriodo);

// PUT update an existing Periodo
router.put('/update/:id', PeriodoController.updatePeriodo);

// DELETE an existing Periodo
// muy probable no considerar esta opción
// router.delete('/:id', PeriodoController.deletePeriodo);

// para los filtros de Periodo
router.get('/search/sede/:codigo', PeriodoController.sedePeriodo);

module.exports = router;
