const express = require('express');
const router = express.Router();
const PlanyCronogramaCompletoController = require('../controllers/plancronograma.controller');

// GET all PlanyCronogramaCompletos
router.get('/', PlanyCronogramaCompletoController.getAllPlanyCronogramaCompletos);

// GET PlanyCronogramaCompleto by id
router.get('/:id', PlanyCronogramaCompletoController.getPlanyCronogramaCompletoById);

// POST a new PlanyCronogramaCompleto
router.post('/create', PlanyCronogramaCompletoController.createPlanyCronogramaCompleto);

// PUT update an existing PlanyCronogramaCompleto
router.put('/update/:id', PlanyCronogramaCompletoController.updatePlanyCronogramaCompleto);

// DELETE an existing PlanyCronogramaCompleto
// muy probable no considerar esta opción
// router.delete('/:id', PlanyCronogramaCompletoController.deletePlanyCronogramaCompleto);

// para los filtros de PlanyCronogramaCompleto
router.get('/search/paciente/:codigo', PlanyCronogramaCompletoController.getPlanyCronogramaCompletoByPaciente);

module.exports = router;
