const express = require('express');
const router = express.Router();
const PruebaOperariaController = require('../controllers/pruebaoperaria.controller');

// GET all PruebaOperarias
router.get('/', PruebaOperariaController.getAllPruebaOperarias);

// GET PruebaOperaria by id
router.get('/:id', PruebaOperariaController.getPruebaOperariaById);

// POST a new PruebaOperaria
router.post('/create', PruebaOperariaController.createPruebaOperaria);

// PUT update an existing PruebaOperaria
router.put('/update/:id', PruebaOperariaController.updatePruebaOperaria);

// DELETE an existing PruebaOperaria
// muy probable no considerar esta opción
// router.delete('/:id', PruebaOperariaController.deletePruebaOperaria);

// para los filtros de PruebaOperaria
router.get('/search/operaria/:codigo', PruebaOperariaController.getPruebaOperariaByOperatoria);

module.exports = router;
