const express = require('express');
const router = express.Router();
const RadiografiaEndodonciaController = require('../controllers/radiografiaendodoncia.controller');

// GET all RadiografiaEndodoncias
router.get('/', RadiografiaEndodonciaController.getAllRadiografiaEndodoncias);

// GET RadiografiaEndodoncia by id
router.get('/:id', RadiografiaEndodonciaController.getRadiografiaEndodonciaById);

// POST a new RadiografiaEndodoncia
router.post('/create', RadiografiaEndodonciaController.createRadiografiaEndodoncia);

// PUT update an existing RadiografiaEndodoncia
router.put('/update/:id', RadiografiaEndodonciaController.updateRadiografiaEndodoncia);

// DELETE an existing RadiografiaEndodoncia
// muy probable no considerar esta opción
// router.delete('/:id', RadiografiaEndodonciaController.deleteRadiografiaEndodoncia);

// para los filtros de RadiografiaEndodoncia
router.get('/search/endodoncia/:codigo', RadiografiaEndodonciaController.getRadiografiaEndodonciaByEndodoncia);

module.exports = router;
