const express = require('express');
const router = express.Router();
const SedeController = require('../controllers/sede.controller');

// GET all Sedes
router.get('/', SedeController.getAllSedes);

// GET Sede by id
router.get('/:id', SedeController.getSedeById);

// POST a new Sede
router.post('/create', SedeController.createSede);

// PUT update an existing Sede
router.put('/update/:id', SedeController.updateSede);

// DELETE an existing Sede
// muy probable no considerar esta opción
// router.delete('/:id', SedeController.deleteSede);

// para los filtros de Sede
router.get('/empresa/:codigo', SedeController.empresaSede);

module.exports = router;
