const express = require('express');
const router = express.Router();
const SubCasoClinicoController = require('../controllers/subcasoclinico.controller');

// GET all SubCasoClinicos
router.get('/', SubCasoClinicoController.getAllSubCasoClinicos);

// GET SubCasoClinico by id
router.get('/:id', SubCasoClinicoController.getSubCasoClinicoById);

// POST a new SubCasoClinico
router.post('/create', SubCasoClinicoController.createSubCasoClinico);

// PUT update an existing SubCasoClinico
router.put('/update/:id', SubCasoClinicoController.updateSubCasoClinico);

// DELETE an existing SubCasoClinico
// muy probable no considerar esta opción
// router.delete('/:id', SubCasoClinicoController.deleteSubCasoClinico);

// para los filtros de SubCasoClinico
router.get('/casoclinico/:codigo', SubCasoClinicoController.getSubCasoClinicoByCasoClinico);

module.exports = router;
