const { PrismaClient } = require('@prisma/client');
const bcrypt = require('bcryptjs');
const prisma = new PrismaClient();

const hoy = new Date();

const Empresas = [ { Ruc: '20319363221', RazonSocial: 'UNIVERSIDAD CONTINENTAL S.A.C', Representante: 'GODOY CASTILLA TERESA' } ]

const Sedes = [
    { 
        Nombre: 'Campus Huancayo',
        Direccion: 'Av. San Carlos 1980',
        Celular: '064-481430',
        Correo: 'campushuancayo@continental.edu.pe',
        TipoSede: 'principal',
        EmpresaId: 1
    },
    { 
        Nombre: 'Campus Los Olivos',
        Direccion: 'Av. Alfredo Mendiola 5210',
        Celular: '01 2132760',
        Correo: 'campuslosolivos@continental.edu.pe',
        TipoSede: 'secundaria',
        EmpresaId: 1
    },
    { 
        Nombre: 'Campus Miraflores',
        Direccion: 'Calle Junín 355',
        Celular: '01 2132760',
        Correo: 'campusmiraflores@continental.edu.pe',
        TipoSede: 'sucursal',
        EmpresaId: 1
    },
    { 
        Nombre: 'Campus Arequipa',
        Direccion: 'José Luis Bustamante y Rivero',
        Celular: '054 412030 Anexo 3000',
        Correo: 'campusarequipa@continental.edu.pe',
        TipoSede: 'sucursal',
        EmpresaId: 1
    },
    { 
        Nombre: 'Campus Cusco',
        Direccion: 'Sector Angostura km. 10, en San Jerónimo',
        Celular: '084 480070',
        Correo: 'campuscusco@continental.edu.pe',
        TipoSede: 'sucursal',
        EmpresaId: 1
    }
]

const Cursos = [
    {
        Nombre: 'Cirujia 1',
        Semestre: 'sexto',
        Malla: '2018'
    },
    {
        Nombre: 'Cirujia 2',
        Semestre: 'septimo',
        Malla: '2018'
    },
    {
        Nombre: 'Cirujia 3',
        Semestre: 'octavo',
        Malla: '2018'
    },
    {
        Nombre: 'Cirujia 4',
        Semestre: 'noveno',
        Malla: '2018'
    },
]

const Periodos = [
    {
        Nombre: '2023-2',
        Empieza: new Date(2023,7,21),
        Termina: new Date(2023,11,21),
        SedeId: 1
    }
]

const Usuarios = [
    {
        Nombre: 'Anibal Jhamil',
        Apellido: 'Huaman Verastein',
        Celular: '958899251',
        Correo: 'anibaljhamil@gmail.com',
        NumDoc: '72547410',
        Contra: '123',
        Foto: 'https://res.cloudinary.com/jx-design/image/upload/v1666925317/Foto/du17hd9gz992fedpcd0e.png',
        Pago: 'soy el god',
        Codigo: '9999999',
        Activo: false,
        Genero: 'masculino',
        TipoDocumento: 'dni',
        RestablecerContra: 'desactivado',
        Rol: 'god',
        SedeId: 1
    },
    {
        Nombre: 'Maycol Rolando',
        Apellido: 'Rodriguez Mallqui',
        Celular: '998238144',
        Correo: 'maycol.rodriguez.ma@gmail.com',
        NumDoc: '71039644',
        Contra: '123',
        Foto: '',
        Pago: 'soy el administrador',
        Codigo: '9999999',
        Activo: false,
        Genero: 'masculino',
        TipoDocumento: 'dni',
        RestablecerContra: 'desactivado',
        Rol: 'administrador',
        SedeId: 1
    },
    {
        Nombre: 'Hector',
        Apellido: 'Chavez Perez',
        Celular: '959933665',
        Correo: 'zeus_apolo85@hotmail.com',
        NumDoc: '77665975',
        Contra: '123',
        Foto: '',
        Pago: 'soy el docente',
        Codigo: '9999999',
        Activo: false,
        Genero: 'masculino',
        TipoDocumento: 'dni',
        RestablecerContra: 'desactivado',
        Rol: 'docente',
        SedeId: 1
    },
    {
        Nombre: 'Flor de Maria',
        Apellido: 'Gutarra Romo',
        Celular: '912597970',
        Correo: '74897825@continental.edu.pe',
        NumDoc: '74897825',
        Contra: '123',
        Foto: '',
        Pago: 'soy el god',
        Codigo: '9999999',
        Activo: false,
        Genero: 'masculino',
        TipoDocumento: 'dni',
        RestablecerContra: 'desactivado',
        Rol: 'estudiante',
        SedeId: 1
    },
]

const Administradores = [
    {
        NombreCompleto: 'Maycol Rolando Rodriguez Mallqui',
        CodigoAcceso: 'fsdfum49m9fcmj4fj4jf3v',
        UsuarioId: 2
    }
]

const Docentes = [
    {
        NombreCompleto: 'Hector Chavez Perez',
        Colegiatura: 'fadsagasdfjv4i3ovjtoi34jtmi34v',
        FirmaDigital: 'gdsagasdg',
        UsuarioId: 3
    }
]

const Estudiantes = [
    {
        NombreCompleto: 'Flor de Maria Gutarra Romo',
        Semestre: 'septimo',
        Firma: 'sdgsdgas',
        UsuarioId: 4
    }
]

const Clases = [
    {
        Nombre: 'el NRC',
        Salon: 'H803',
        Horario: 'Lunes de 9:00 am hasta 12:10 pm',
        idDocente: 1,
        idPeriodo: 1,
        idCurso: 1
    }
]

const Integrantes = [
    {
        Nombre: 'el nrc - nombre completo estudiante',
        ClaseId: 1,
        EstudianteId: 1
    }
]

const Pacientes = [
    {
        FechaCreacion: hoy,
        HoraCreacion: hoy,
        NumeroHistoriaClinica: '72547410',
        Ectoscopia: '',
        Nombre: 'Anibal Jhamil',
        ApellidoPaterno: 'Huaman',
        ApellidoMaterno: 'Verastein',
        Sexo: 'masculino',
        Lugar: 'Huancayo',
        Domicilio: 'Calle Cantuta 124',
        FechaNacimiento: new Date(1997,3,11),
        EstadoCivil: 'soltero',
        NroCelular: '958899251',
        Correo: 'anibaljhamil',
        Raza: 'mestizo',
        GradoInstruccion: 'superior tecnico completo',
        Ocupacion: 'tecnico asistencial',
        Responsable: '',
        ParentescoconResponsable: '',
        DomicilioResponsable: '',
        CelularResponsable: '',
        Acompaniante: '',
        EnfermedadActual: '',
        MotivoConsulta: '',
        FuncionesBiologicas: '',
        Orina: '',
        Apetito: '',
        Suenio: '',
        Deposiciones: '',
        Sed: '',
        Alergias: '',
        AntecedentesAlergicos: '',
        AntecedentesPersonal: '',
        AntecedentesFamiliar: '',
        AntecedentesPatologicos: '',
        SedeId: 1,
        UsuarioId: 4
    }
]

// const Dientes = [
//     {
//         Nombre: '',
//         Ubicacion: '',
//         Tipo: '',
//         Lado: '',
//         Posicion: '',
//         Raiz: '',
//         Estado: ''
//     }
// ]

// const CasosClinicos = [
//     {
//         Nombre: ''
//     }
// ]

// const SubCasosClinicos = [
//     {
//         Nombre: '',
//         CasoClinicoId: 1
//     }
// ]

// const CasosDiente = [
//     {
//         Nombre: '',
//         Foto: '',
//         SubCasoClinicoId: 1,
//         DienteId: 1
//     }
// ]



async function seed() {
    // await Promise.all(
    console.log('Iniciando la insercion de datos en las tablas');
    console.log('-----------------------------');
    console.log('------------empresas-----------');
    for (const dataempresa of Empresas) {
        await prisma.empresa.create({data: dataempresa});
        console.log(`Se ha creado un nueva empresa: ${dataempresa.RazonSocial}`);
    }
    console.log('------------sedes-----------');
    for (const datasede of Sedes) {
        await prisma.sede.create({data: datasede});
        console.log(`Se ha creado una nueva sede: ${datasede.Nombre}`);
    }
    console.log('------------cursos-----------');
    for (const datacurso of Cursos) {
        await prisma.curso.create({data: datacurso});
        console.log(`Se ha creado un nuevo curso: ${datacurso.Nombre}`);
    }
    console.log('------------periodo-----------');
    for (const dataperiodo of Periodos) {
        await prisma.periodo.create({data: dataperiodo});
        console.log(`Se ha creado un nuevo periodo: ${dataperiodo.Nombre}`);
    }
    console.log('------------usuarios-----------');
    for (const datausuario of Usuarios) {
        const hashedPassword = await bcrypt.hash(datausuario.Contra, 15);
        datausuario.Contra = hashedPassword;
        await prisma.usuario.create({data: datausuario});
        console.log(`Se ha creado un(a) nuev@ usuario: ${datausuario.Nombre}`);
    }
    console.log('------------administrador-----------');
    for (const dataadministrador of Administradores) {
        await prisma.administrador.create({data: dataadministrador});
        console.log(`Se ha creado un(a) nuev@ administrador: ${dataadministrador.NombreCompleto}`);
    }
    console.log('------------docente-----------');
    for (const datadocente of Docentes) {
        await prisma.docente.create({data: datadocente});
        console.log(`Se ha creado un(a) nuev@ docente: ${datadocente.NombreCompleto}`);
    }
    console.log('------------estudiante-----------');
    for (const dataestudiante of Estudiantes) {
        await prisma.estudiante.create({data: dataestudiante});
        console.log(`Se ha creado un(a) nuev@ estudiante: ${dataestudiante.NombreCompleto}`);
    }
    console.log('------------clase-----------');
    for (const dataclase of Clases) {
        await prisma.clase.create({data: dataclase});
        console.log(`Se ha creado una nueva clase: ${dataclase.Nombre}`);
    }
    console.log('------------integrante-----------');
    for (const dataintegrante of Integrantes) {
        await prisma.integrante.create({data: dataintegrante});
        console.log(`Se ha creado un nuevo integrante: ${dataintegrante.Nombre}`);
    }
    console.log('------------paciente-----------');
    for (const datapaciente of Pacientes) {
        await prisma.paciente.create({data: datapaciente});
        console.log(`Se ha creado un nuevo paciente: ${datapaciente.Nombre}`);
    }
    console.log('-----------------------------');
    console.log('Insercion de tablas finalizado');
    // );
}

seed()
    .catch((e) => {
        console.error(e)
        process.exit(1)
    })
    .finally(async () => {
        await prisma.$disconnect()
    })

    